/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.scripting;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.ProcessRunner;
import com.aptana.plist.PListParserFactory;
import com.aptana.scripting.CommandConverter;
import com.aptana.scripting.ScriptingActivator;
import com.aptana.scripting.SnippetConverter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleConverter {
    private static Map<Character, Character> shiftChars = new HashMap<Character, Character>();

    static {
        shiftChars.put(Character.valueOf('_'), Character.valueOf('-'));
        shiftChars.put(Character.valueOf('!'), Character.valueOf('1'));
        shiftChars.put(Character.valueOf('@'), Character.valueOf('2'));
        shiftChars.put(Character.valueOf('#'), Character.valueOf('3'));
        shiftChars.put(Character.valueOf('$'), Character.valueOf('4'));
        shiftChars.put(Character.valueOf('%'), Character.valueOf('5'));
        shiftChars.put(Character.valueOf('^'), Character.valueOf('6'));
        shiftChars.put(Character.valueOf('&'), Character.valueOf('7'));
        shiftChars.put(Character.valueOf('*'), Character.valueOf('8'));
        shiftChars.put(Character.valueOf('('), Character.valueOf('9'));
        shiftChars.put(Character.valueOf(')'), Character.valueOf('0'));
        shiftChars.put(Character.valueOf('+'), Character.valueOf('='));
        shiftChars.put(Character.valueOf('{'), Character.valueOf('['));
        shiftChars.put(Character.valueOf('}'), Character.valueOf(']'));
        shiftChars.put(Character.valueOf('|'), Character.valueOf('\\'));
        shiftChars.put(Character.valueOf(':'), Character.valueOf(';'));
        shiftChars.put(Character.valueOf('\"'), Character.valueOf('\''));
        shiftChars.put(Character.valueOf('<'), Character.valueOf(','));
        shiftChars.put(Character.valueOf('>'), Character.valueOf('.'));
        shiftChars.put(Character.valueOf('?'), Character.valueOf('/'));
        shiftChars.put(Character.valueOf('~'), Character.valueOf('`'));
    }

    public static void main(String[] args) throws Exception {
        String userHome = System.getProperty("user.home");
        if (args == null || args.length == 0) {
            args = new String[]{"/Applications/TextMate.app/Contents/SharedSupport/Bundles"};
        }
        String outputDir = String.valueOf(userHome) + "/Documents/Aptana Rubles";
        if (args.length > 1) {
            outputDir = args[1];
        }
        String[] bundleFilter = new String[]{"Property List"};
        File[] bundles = BundleConverter.gatherBundles(new File(args[0]));
        if (bundles == null) {
            System.out.println("No bundles found in dir: " + args[0]);
            return;
        }
        File[] fileArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            File textmateBundleDir = fileArray[n2];
            String nameWithoutExtension = textmateBundleDir.getName().substring(0, textmateBundleDir.getName().length() - 9);
            String[] stringArray = bundleFilter;
            int n3 = bundleFilter.length;
            int n4 = 0;
            while (n4 < n3) {
                String bundleToConvert = stringArray[n4];
                if (bundleToConvert.equalsIgnoreCase(nameWithoutExtension)) {
                    BundleConverter.convertBundle(textmateBundleDir, String.valueOf(outputDir) + File.separator + nameWithoutExtension + ".ruble");
                }
                ++n4;
            }
            ++n2;
        }
    }

    private static File[] gatherBundles(File bundlesDir) {
        return bundlesDir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith("tmbundle");
            }
        });
    }

    public static void convertBundle(File bundleDir, String outputBundlePath) throws IOException {
        HashMap<String, String> uuidToName = new HashMap<String, String>();
        File snippetsDir = new File(bundleDir, "Snippets");
        SnippetConverter.convert(snippetsDir, String.valueOf(outputBundlePath) + File.separator + "snippets" + File.separator + "snippets.rb");
        uuidToName.putAll(SnippetConverter.uuidNameMap(snippetsDir));
        File commandsDir = new File(bundleDir, "Commands");
        CommandConverter.convert(commandsDir, String.valueOf(outputBundlePath) + File.separator + "commands");
        uuidToName.putAll(CommandConverter.uuidNameMap(commandsDir));
        String bundleRBPath = String.valueOf(outputBundlePath) + File.separator + "bundle.rb";
        String contents = BundleConverter.convertInfoPlist(new File(bundleDir, "Info.plist"), uuidToName);
        BundleConverter.writeToFile(contents, bundleRBPath);
        BundleConverter.copyDir(bundleDir + "/Tests/", String.valueOf(outputBundlePath) + "/tests");
        BundleConverter.copyDir(bundleDir + "/Support/", String.valueOf(outputBundlePath) + "/lib");
        BundleConverter.copyDir(bundleDir + "/Preferences/", String.valueOf(outputBundlePath) + "/unsupported/preferences");
        BundleConverter.copyDir(bundleDir + "/Macros/", String.valueOf(outputBundlePath) + "/unsupported/macros");
        BundleConverter.copyDir(bundleDir + "/DragCommands/", String.valueOf(outputBundlePath) + "/unsupported/drag_commands");
        BundleConverter.copyDir(bundleDir + "/Templates/", String.valueOf(outputBundlePath) + "/unsupported/templates");
    }

    private static boolean copyDir(String srcPath, String destPath) {
        return BundleConverter.copyDir(Path.fromOSString((String)srcPath), Path.fromOSString((String)destPath));
    }

    private static boolean copyDir(IPath srcPath, IPath destPath) {
        if (!srcPath.toFile().exists()) {
            return true;
        }
        try {
            destPath.toFile().mkdirs();
            Process p = new ProcessRunner().run(new String[]{"cp", "-R", srcPath.toOSString(), destPath.toOSString()});
            p.waitFor();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return false;
    }

    private static String convertInfoPlist(File plistFile, Map<String, String> uuidToName) {
        Map<String, Object> properties = BundleConverter.parse(plistFile);
        StringBuilder buffer = new StringBuilder();
        buffer.append("require 'ruble'\n\n");
        String name = BundleConverter.sanitize(properties, "name");
        buffer.append("bundle '").append(name).append("' do |bundle|\n");
        buffer.append("  bundle.author = '").append(BundleConverter.sanitize(properties, "contactName")).append("'\n");
        buffer.append("  bundle.contact_email_rot_13 = '").append(BundleConverter.sanitize(properties, "contactEmailRot13")).append("'\n");
        buffer.append("  bundle.description =  <<END\n").append((String)properties.get("description")).append("\nEND\n");
        File prefsDir = new File(plistFile.getParentFile(), "Preferences");
        buffer.append(BundleConverter.addIndents(prefsDir));
        File syntaxesDir = new File(plistFile.getParentFile(), "Syntaxes");
        buffer.append(BundleConverter.addFolding(syntaxesDir));
        buffer.append(BundleConverter.addFileTypes(syntaxesDir));
        Map mainMenu = (Map)properties.get("mainMenu");
        if (mainMenu != null) {
            Map submenus = (Map)mainMenu.get("submenus");
            buffer.append("\n  bundle.menu '").append(name).append("' do |main_menu|\n");
            buffer.append(BundleConverter.handleMenu("    main_menu", submenus, (List)mainMenu.get("items"), uuidToName));
            buffer.append("  end\n");
        } else {
            List items = (List)properties.get("ordering");
            buffer.append("\n  bundle.menu '").append(name).append("' do |main_menu|\n");
            buffer.append(BundleConverter.handleMenu("    main_menu", new HashMap<String, Object>(), items, uuidToName));
            buffer.append("  end\n");
        }
        buffer.append("end\n");
        buffer.append(BundleConverter.addEnv(prefsDir));
        buffer.append(BundleConverter.addSmartTypingPairs(prefsDir));
        return buffer.toString();
    }

    private static String addIndents(File prefsDir) {
        StringBuilder builder = new StringBuilder();
        if (prefsDir == null || !prefsDir.isDirectory()) {
            return builder.toString();
        }
        File[] files = prefsDir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".plist");
            }
        });
        if (files == null || files.length < 1) {
            return builder.toString();
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            Map settings;
            File prefsFile = fileArray[n2];
            Map<String, Object> properties = BundleConverter.parse(prefsFile);
            if (properties != null && properties.containsKey("settings") && (settings = (Map)properties.get("settings")).containsKey("increaseIndentPattern")) {
                String scope = (String)properties.get("scope");
                String increase = (String)settings.get("increaseIndentPattern");
                increase = BundleConverter.sanitizeRegexp(increase);
                builder.append("  increase_indent = /").append(increase).append("/\n");
                if (settings.containsKey("decreaseIndentPattern")) {
                    String decrease = (String)settings.get("decreaseIndentPattern");
                    decrease = BundleConverter.sanitizeRegexp(decrease);
                    builder.append("  decrease_indent = /").append(decrease).append("/\n");
                    builder.append("  bundle.indent['").append(scope).append("'] = increase_indent, decrease_indent\n");
                }
            }
            ++n2;
        }
        return builder.toString();
    }

    protected static String sanitizeRegexp(String regexp) {
        return regexp.replace("''", "'").replace("/", "\\/");
    }

    private static String addFileTypes(File syntaxesDir) {
        StringBuilder builder = new StringBuilder();
        if (syntaxesDir == null || !syntaxesDir.isDirectory()) {
            return builder.toString();
        }
        File[] files = syntaxesDir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".tmLanguage") || name.endsWith(".plist");
            }
        });
        if (files == null || files.length < 1) {
            return builder.toString();
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File syntaxFile = fileArray[n2];
            Map<String, Object> properties = BundleConverter.parse(syntaxFile);
            String scope = (String)properties.get("scopeName");
            List fileTypes = (List)properties.get("fileTypes");
            if (fileTypes != null && !fileTypes.isEmpty()) {
                builder.append("  bundle.file_types['").append(scope).append("'] = ");
                for (String fileType : fileTypes) {
                    String pattern = "*." + fileType;
                    if (fileType.contains(".") || Character.isUpperCase(fileType.charAt(0))) {
                        pattern = fileType;
                    }
                    builder.append("'").append(pattern).append("', ");
                }
                builder.delete(builder.length() - 2, builder.length());
                builder.append("\n");
            }
            ++n2;
        }
        return builder.toString();
    }

    private static String addFolding(File syntaxesDir) {
        StringBuilder builder = new StringBuilder();
        if (syntaxesDir == null || !syntaxesDir.isDirectory()) {
            return builder.toString();
        }
        File[] files = syntaxesDir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".tmLanguage") || name.endsWith(".plist");
            }
        });
        if (files == null || files.length < 1) {
            return builder.toString();
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            boolean hasStop;
            File syntaxFile = fileArray[n2];
            Map<String, Object> properties = BundleConverter.parse(syntaxFile);
            String scope = (String)properties.get("scopeName");
            boolean hasStart = properties.containsKey("foldingStartMarker");
            if (hasStart) {
                String folding = (String)properties.get("foldingStartMarker");
                folding = BundleConverter.sanitizeRegexp(folding);
                builder.append("  start_folding = /").append(folding).append("/\n");
            }
            if (hasStop = properties.containsKey("foldingStopMarker")) {
                String folding = (String)properties.get("foldingStopMarker");
                folding = BundleConverter.sanitizeRegexp(folding);
                builder.append("  end_folding = /").append(folding).append("/\n");
            }
            if (hasStart && hasStop) {
                builder.append("  bundle.folding['").append(scope).append("'] = start_folding, end_folding\n");
            }
            ++n2;
        }
        return builder.toString();
    }

    private static String addEnv(File syntaxesDir) {
        StringBuilder builder = new StringBuilder();
        if (syntaxesDir == null || !syntaxesDir.isDirectory()) {
            return builder.toString();
        }
        File[] files = syntaxesDir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".tmLanguage") || name.endsWith(".plist");
            }
        });
        if (files == null || files.length < 1) {
            return builder.toString();
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File syntaxFile = fileArray[n2];
            Map<String, Object> properties = BundleConverter.parse(syntaxFile);
            String scope = (String)properties.get("scope");
            Map settings = (Map)properties.get("settings");
            boolean hasStart = settings.containsKey("shellVariables");
            if (hasStart) {
                List variables = (List)settings.get("shellVariables");
                builder.append("env '").append(scope).append("' do |e|\n");
                for (Map var : variables) {
                    builder.append("  e['").append(var.get("name")).append("'] = ");
                    builder.append("'").append(var.get("value")).append("'\n");
                }
                builder.append("end\n");
            }
            ++n2;
        }
        return builder.toString();
    }

    private static String addSmartTypingPairs(File syntaxesDir) {
        StringBuilder builder = new StringBuilder();
        if (syntaxesDir == null || !syntaxesDir.isDirectory()) {
            return builder.toString();
        }
        File[] files = syntaxesDir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".tmLanguage") || name.endsWith(".plist");
            }
        });
        if (files == null || files.length < 1) {
            return builder.toString();
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File syntaxFile = fileArray[n2];
            Map<String, Object> properties = BundleConverter.parse(syntaxFile);
            String scope = (String)properties.get("scope");
            Map settings = (Map)properties.get("settings");
            boolean hasStart = settings.containsKey("smartTypingPairs");
            if (hasStart) {
                builder.append("smart_typing_pairs['").append(scope).append("'] = [");
                List pairs = (List)settings.get("smartTypingPairs");
                for (List pair : pairs) {
                    for (String pairChar : pair) {
                        if (pairChar.equals("'")) {
                            pairChar = "\\'";
                        }
                        builder.append("'").append(pairChar).append("', ");
                    }
                }
                builder.deleteCharAt(builder.length() - 1);
                builder.deleteCharAt(builder.length() - 1);
                builder.append("]\n");
            }
            ++n2;
        }
        return builder.toString();
    }

    protected static String handleMenu(String menuPrefix, Map<String, Object> submenus, List<String> items, Map<String, String> uuidToName) {
        if (items == null) {
            return "";
        }
        int spaces = menuPrefix.length() - menuPrefix.trim().length();
        String indent = "";
        int i = 0;
        while (i < spaces) {
            indent = String.valueOf(indent) + " ";
            ++i;
        }
        StringBuilder buffer = new StringBuilder();
        for (String uuid : items) {
            if (uuid.contains("-------")) {
                buffer.append(menuPrefix).append(".separator\n");
                continue;
            }
            Map props = (Map)submenus.get(uuid);
            if (props != null) {
                String subMenuName = (String)props.get("name");
                buffer.append(menuPrefix).append(".menu '").append(subMenuName).append("' do |submenu|\n");
                buffer.append(BundleConverter.handleMenu(String.valueOf(indent) + "  submenu", submenus, (List)props.get("items"), uuidToName));
                buffer.append(indent).append("end\n");
                continue;
            }
            String commandName = uuidToName.get(uuid);
            if (commandName == null) {
                buffer.append("#").append(menuPrefix).append(".command '").append(uuid).append("'\n");
                continue;
            }
            buffer.append(menuPrefix).append(".command '").append(commandName).append("'\n");
        }
        return buffer.toString();
    }

    static Map<String, Object> parse(File plistFile) {
        return BundleConverter.parse(Path.fromOSString((String)plistFile.getAbsolutePath()));
    }

    static Map<String, Object> parse(IPath plistPath) {
        try {
            return PListParserFactory.parse((File)plistPath.toFile());
        }
        catch (IOException e) {
            IdeLog.logError((Plugin)ScriptingActivator.getDefault(), (String)e.getMessage(), (Throwable)e);
            return Collections.emptyMap();
        }
    }

    protected static String sanitize(Map<String, Object> properties, String key) {
        String content = (String)properties.get(key);
        if (content == null) {
            return null;
        }
        return content.replace("'", "\\'").replace("\u2026", "...").replace("\u2014", "-");
    }

    static void writeToFile(String output, String outFilePath) throws IOException {
        Writer writer = null;
        try {
            File outFile = new File(outFilePath);
            outFile.getParentFile().mkdirs();
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), "UTF-8");
            writer.write(output);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    static String convertKeyBinding(String keyBinding) {
        if (keyBinding == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < keyBinding.length()) {
            char c = keyBinding.charAt(i);
            switch (c) {
                case '\uf704': {
                    builder.append("F1+");
                    break;
                }
                case '\uf705': {
                    builder.append("F2+");
                    break;
                }
                case '\uf706': {
                    builder.append("F3+");
                    break;
                }
                case '\uf707': {
                    builder.append("F4+");
                    break;
                }
                case '\uf708': {
                    builder.append("F5+");
                    break;
                }
                case '\uf709': {
                    builder.append("F6+");
                    break;
                }
                case '\uf70a': {
                    builder.append("F7+");
                    break;
                }
                case '\uf70b': {
                    builder.append("F8+");
                    break;
                }
                case '\uf70c': {
                    builder.append("F9+");
                    break;
                }
                case '\uf70d': {
                    builder.append("F10+");
                    break;
                }
                case '\uf70e': {
                    builder.append("F11+");
                    break;
                }
                case '\uf70f': {
                    builder.append("F12+");
                    break;
                }
                case '@': {
                    builder.append("M1+");
                    break;
                }
                case '^': {
                    builder.append("M4+");
                    break;
                }
                case '~': {
                    builder.append("M3+");
                    break;
                }
                case '$': {
                    builder.append("M2+");
                    break;
                }
                case '\n': {
                    builder.append("ENTER+");
                    break;
                }
                case '\u001b': {
                    builder.append("ESCAPE+");
                    break;
                }
                case '\u007f': {
                    builder.append("DEL+");
                    break;
                }
                default: {
                    if (Character.isLetter(c) && Character.isUpperCase(c)) {
                        builder.append("M2+");
                    }
                    builder.append(Character.toUpperCase(c)).append('+');
                }
            }
            ++i;
        }
        if (keyBinding.length() > 0) {
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }
}

